<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserBox extends Model 
{

    protected $table = 'users_box';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('box_id', 'user_id', 'slug', 'start_date', 'end_date', 'commission', 'cash', 'uv', 'status');
    protected $visible = array('box_id', 'user_id', 'slug', 'start_date', 'end_date', 'commission', 'cash', 'uv', 'status');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function box()
    {
        return $this->belongsTo('App\Models\Box', 'box_id');
    }

    public function cashsStatement()
    {
        return $this->hasMany('App\Models\CashStatement', 'user_box_id');
    }

    public function reloadsUV()
    {
        return $this->hasMany('App\Models\ReloadUV', 'user_box_id');
    }

    public function amountCashUserBoxCurrency()
    {
        return $this->hasMany('App\Models\AmountCashUserBoxCurrency', 'user_box_id');
    }

}